/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.modelgen;

import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.RemoteStatusImpl;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.CriticalStatusScalarItem;
import ibm.nways.jdm.modelgen.GeneratedRemoteStatusImpl;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.modelgen.LocalStatus;
import ibm.nways.jdm.modelgen.LocalTableStatus;
import ibm.nways.jdm.modelgen.StatusMapper;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class StatusModelInfo
extends StatusImpl
implements Serializable,
LocalStatus {
    private Vector criticalScalars;
    private transient LocalModel locmod;
    private transient StatusMapper mapper;
    private transient ModelInfo info;
    private transient GeneratedRemoteStatusImpl rs;
    private transient int useCount;
    private transient boolean sendSpecialValues;

    public StatusModelInfo(LocalModel localModel, StatusMapper statusMapper, boolean bl) {
        this.locmod = localModel;
        this.mapper = statusMapper;
        this.info = new ModelInfo();
        this.rs = null;
        this.sendSpecialValues = bl;
    }

    public synchronized Serializable get(String string) {
        return this.info.get(string);
    }

    public synchronized void add(String string, Serializable serializable) {
        Object object;
        StatusModelInfo statusModelInfo = new StatusModelInfo(this.locmod, this.mapper, this.sendSpecialValues);
        Enumeration enumeration = this.info.getItemIds();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            statusModelInfo.info.add((String)object, this.info.get((String)object));
        }
        this.info.add(string, serializable);
        object = this.getStatusType();
        I18NString i18NString = this.getExplanation();
        boolean bl = this.isCritical();
        if (!(serializable instanceof SpecialValue) || this.sendSpecialValues) {
            try {
                this.mapper.calculateStatus(this, statusModelInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.setStatusType(StatusType.UNKNOWN, null);
        }
        this.checkCritical();
        this.setRemoteStatus((StatusType)object, i18NString, bl);
    }

    public synchronized void add(String[] stringArray, Serializable[] serializableArray) {
        StatusModelInfo statusModelInfo = new StatusModelInfo(this.locmod, this.mapper, this.sendSpecialValues);
        boolean bl = false;
        Enumeration enumeration = this.info.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            statusModelInfo.info.add(string, this.info.get(string));
        }
        int n = 0;
        while (n < stringArray.length) {
            this.info.add(stringArray[n], serializableArray[n]);
            if (serializableArray[n] instanceof SpecialValue) {
                bl = true;
            }
            ++n;
        }
        StatusType statusType = this.getStatusType();
        I18NString i18NString = this.getExplanation();
        boolean bl2 = this.isCritical();
        if (!bl || this.sendSpecialValues) {
            try {
                this.mapper.calculateStatus(this, statusModelInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.setStatusType(StatusType.UNKNOWN, null);
        }
        this.checkCritical();
        this.setRemoteStatus(statusType, i18NString, bl2);
    }

    private void checkCritical() {
        boolean bl = false;
        if (this.locmod == null) {
            return;
        }
        if (this.locmod.statusType == 2) {
            bl = this.isRowCritical();
            if (this.isCritical() != bl) {
                this.setCritical(bl);
                return;
            }
        } else if (this.locmod.statusType == 1) {
            bl = this.isCriticalScalar();
            if (this.isCritical() != bl) {
                this.setCritical(bl);
                if (this.isCritical() && (this.getStatusType() == StatusType.CRITICAL || this.getStatusType() == StatusType.MARGINAL)) {
                    this.setStatusType(StatusType.CRITICAL, this.getExplanation());
                }
            }
        }
    }

    private void setRemoteStatus(StatusType statusType, I18NString i18NString, boolean bl) {
        RemoteStatusImpl remoteStatusImpl = null;
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            try {
                remoteStatusImpl = this.getRemoteStatusObj();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (statusType != this.getStatusType() || !I18NString.equal(i18NString, this.getExplanation()) || this.isCritical() != bl) {
            try {
                if (remoteStatusImpl != null) {
                    remoteStatusImpl.setStatusType(this.getStatusType(), this.getExplanation(), true);
                    if (this.isCritical() != bl) {
                        remoteStatusImpl.setCritical(this.isCritical());
                        return;
                    }
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public Enumeration getItemIds() {
        return this.info.getItemIds();
    }

    public LocalModel getLocalModel() {
        return this.locmod;
    }

    public Serializable[] getIndexes() {
        if (this.locmod == null) {
            return null;
        }
        return this.locmod.getIndexes();
    }

    public RemoteStatusImpl getRemoteStatusObj() throws RemoteException {
        GeneratedRemoteStatusImpl generatedRemoteStatusImpl = null;
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            if (this.rs == null) {
                this.rs = new GeneratedRemoteStatusImpl(this);
            }
            generatedRemoteStatusImpl = this.rs;
        }
        return generatedRemoteStatusImpl;
    }

    public void clearRemoteStatusObj() {
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            if (this.rs != null) {
                try {
                    this.rs.deleteWatchers();
                }
                catch (Exception exception) {}
            }
            this.rs = null;
            return;
        }
    }

    public void startStatus() {
        if (this.locmod == null) {
            return;
        }
        boolean bl = false;
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            ++this.useCount;
            if (this.useCount == 1) {
                bl = true;
            }
        }
        if (bl) {
            this.locmod.startStatus();
        }
    }

    public void stopStatus() {
        boolean bl = false;
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            --this.useCount;
            if (this.useCount <= 0) {
                bl = true;
                this.useCount = 0;
            }
        }
        if (bl && this.locmod != null) {
            this.locmod.stopStatus();
        }
    }

    public void reallyStopStatus() {
        StatusModelInfo statusModelInfo = this;
        synchronized (statusModelInfo) {
            this.useCount = 0;
            if (this.locmod != null) {
                this.locmod.instr.stopMonitor(this.locmod, this.locmod.getIndexes(), this.locmod.context);
                this.locmod = null;
            }
            return;
        }
    }

    public void refreshStatus() {
        if (this.locmod != null) {
            this.locmod.refreshStatus();
        }
    }

    private boolean isRowCritical() {
        LocalModel localModel = this.locmod.getParentModel();
        LocalTableStatus localTableStatus = null;
        boolean bl = false;
        localTableStatus = (LocalTableStatus)localModel.getLocalStatus("default");
        if (localTableStatus != null) {
            Vector vector = localTableStatus.getCriticalRows();
            if (vector == null) {
                return bl;
            }
            OID oID = this.locmod.getIndexOID();
            if (oID != null && vector.contains(oID)) {
                bl = true;
            }
        }
        return bl;
    }

    private Vector getCriticalScalars() {
        String string;
        Serializable serializable;
        if (this.criticalScalars == null && (serializable = this.locmod.getPersistentInfo(string = "default.scalars")) != null) {
            this.criticalScalars = (Vector)serializable;
        }
        return this.criticalScalars;
    }

    private boolean isCriticalScalar() {
        boolean bl = false;
        if (this.locmod.statusType == 1 && this.getCriticalScalars() != null && this.info != null && this.getCriticalScalarIndex(this.info) >= 0) {
            bl = true;
        }
        return bl;
    }

    public void setCriticalScalar(ModelInfo modelInfo, boolean bl) {
        if (this.locmod.statusType == 1) {
            if (this.criticalScalars == null && this.getCriticalScalars() == null) {
                this.criticalScalars = new Vector();
            }
            if (modelInfo != null) {
                StatusModelInfo statusModelInfo = this;
                synchronized (statusModelInfo) {
                    int n = this.getCriticalScalarIndex(modelInfo);
                    if (bl && n < 0) {
                        CriticalStatusScalarItem criticalStatusScalarItem = new CriticalStatusScalarItem(modelInfo);
                        this.criticalScalars.addElement(criticalStatusScalarItem);
                    } else if (!bl && n >= 0) {
                        this.criticalScalars.removeElementAt(n);
                    }
                }
                this.locmod.savePersistentInfo("default.scalars", this.criticalScalars);
            }
            this.setCritical(bl);
        }
    }

    private int getCriticalScalarIndex(ModelInfo modelInfo) {
        int n = -1;
        if (modelInfo == null) {
            return n;
        }
        modelInfo.getItemIds();
        int n2 = 0;
        while (n2 < this.criticalScalars.size()) {
            CriticalStatusScalarItem criticalStatusScalarItem = (CriticalStatusScalarItem)this.criticalScalars.elementAt(n2);
            if (criticalStatusScalarItem.contains(modelInfo)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }
}

